/* ====================================================================
 * Copyright (c) 2001-2016 The OpenSSL Project.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. All advertising materials mentioning features or use of this
 *    software must display the following acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit. (http://www.openssl.org/)"
 *
 * 4. The names "OpenSSL Toolkit" and "OpenSSL Project" must not be used to
 *    endorse or promote products derived from this software without
 *    prior written permission. For written permission, please contact
 *    openssl-core@openssl.org.
 *
 * 5. Products derived from this software may not be called "OpenSSL"
 *    nor may "OpenSSL" appear in their names without prior written
 *    permission of the OpenSSL Project.
 *
 * 6. Redistributions of any form whatsoever must retain the following
 *    acknowledgment:
 *    "This product includes software developed by the OpenSSL Project
 *    for use in the OpenSSL Toolkit (http://www.openssl.org/)"
 *
 * THIS SOFTWARE IS PROVIDED BY THE OpenSSL PROJECT ``AS IS'' AND ANY
 * EXPRESSED OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE OpenSSL PROJECT OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 * ====================================================================
 *
 * This product includes cryptographic software written by Eric Young
 * (eay@cryptsoft.com).  This product includes software written by Tim
 * Hudson (tjh@cryptsoft.com).
 *
 */

#ifndef HEADER_SDC_ECM_ERR_H
#define HEADER_SDC_ECM_ERR_H

#ifdef  __cplusplus
extern "C" {
#endif

/* BEGIN ERROR CODES */
/*
 * The following lines are auto generated by the script mkerr.pl. Any changes
 * made after this point may be overwritten when the script is next run.
 */
void ERR_load_SDC_ECM_strings(void);
void ERR_unload_SDC_ECM_strings(void);
void ERR_SDC_ECM_error(int function, int reason, char *file, int line);
# define SDC_ECMerr(f,r) ERR_SDC_ECM_error((f),(r),__FILE__,__LINE__)

/* Error codes for the SDC_ECM functions. */

/* Function codes. */
# define SDC_ECM_F_BIND                                   100
# define SDC_ECM_F_CTRL                                   101
# define SDC_ECM_F_DBUS_CHECK_CERT                        151
# define SDC_ECM_F_DBUS_CONNECT                           149
# define SDC_ECM_F_DBUS_WATCH_NAME                        148
# define SDC_ECM_F_DESTROY                                102
# define SDC_ECM_F_DIGEST                                 161
# define SDC_ECM_F_FINISH                                 103
# define SDC_ECM_F_GATEWAY_IFACE_INIT                     147
# define SDC_ECM_F_GATEWAY_IFACE_SET_BUS_NAME             152
# define SDC_ECM_F_GATEWAY_IFACE_SET_BUS_TYPE             150
# define SDC_ECM_F_GATEWAY_IFACE_SET_INTERFACE_NAME       153
# define SDC_ECM_F_GATEWAY_LOAD_KEY                       155
# define SDC_ECM_F_GATEWAY_SIGN                           157
# define SDC_ECM_F_GATEWAY_VERIFY                         158
# define SDC_ECM_F_INIT                                   104
# define SDC_ECM_F_LOAD_CERT                              105
# define SDC_ECM_F_LOAD_CLIENT_CERT                       106
# define SDC_ECM_F_LOAD_PRIVKEY                           107
# define SDC_ECM_F_LOAD_PUBKEY                            108
# define SDC_ECM_F_PARAMS_CHECK_CERT_NEW                  146
# define SDC_ECM_F_PKEY_ASN1_METHS                        109
# define SDC_ECM_F_PKEY_ASN1_METH_INIT                    110
# define SDC_ECM_F_PKEY_ASN1_PUB_BITS                     111
# define SDC_ECM_F_PKEY_ASN1_PUB_CMP                      112
# define SDC_ECM_F_PKEY_ASN1_PUB_DECODE                   113
# define SDC_ECM_F_PKEY_ASN1_PUB_ENCODE                   114
# define SDC_ECM_F_PKEY_ASN1_PUB_PRINT                    115
# define SDC_ECM_F_PKEY_ASN1_PUB_SIZE                     116
# define SDC_ECM_F_PKEY_CLEANUP                           117
# define SDC_ECM_F_PKEY_COPY                              118
# define SDC_ECM_F_PKEY_CTRL                              159
# define SDC_ECM_F_PKEY_CTRL_STR                          160
# define SDC_ECM_F_PKEY_DECRYPT                           119
# define SDC_ECM_F_PKEY_DECRYPT_INIT                      120
# define SDC_ECM_F_PKEY_ENCRYPT                           121
# define SDC_ECM_F_PKEY_ENCRYPT_INIT                      122
# define SDC_ECM_F_PKEY_INIT                              123
# define SDC_ECM_F_PKEY_METHS                             124
# define SDC_ECM_F_PKEY_METH_INIT                         125
# define SDC_ECM_F_PKEY_SIGN                              126
# define SDC_ECM_F_PKEY_SIGNCTX                           127
# define SDC_ECM_F_PKEY_SIGNCTX_INIT                      128
# define SDC_ECM_F_PKEY_SIGN_INIT                         129
# define SDC_ECM_F_PKEY_VERIFY                            130
# define SDC_ECM_F_PKEY_VERIFYCTX                         131
# define SDC_ECM_F_PKEY_VERIFYCTX_INIT                    132
# define SDC_ECM_F_PKEY_VERIFY_INIT                       133
# define SDC_ECM_F_PKEY_VERIFY_RECOVER                    134
# define SDC_ECM_F_PKEY_VERIFY_RECOVER_INIT               135
# define SDC_ECM_F_RSA_BN_MOD_EXP                         136
# define SDC_ECM_F_RSA_FINISH                             137
# define SDC_ECM_F_RSA_INIT                               138
# define SDC_ECM_F_RSA_MOD_EXP                            139
# define SDC_ECM_F_RSA_PRIV_DEC                           140
# define SDC_ECM_F_RSA_PRIV_ENC                           141
# define SDC_ECM_F_RSA_PUB_DEC                            142
# define SDC_ECM_F_RSA_PUB_ENC                            143
# define SDC_ECM_F_RSA_SIGN                               144
# define SDC_ECM_F_RSA_VERIFY                             145
# define SDC_ECM_F_SET_CHECK_CERT_MODE                    154

/* Reason codes. */
# define SDC_ECM_R_CLIENT_CERT_NOT_IMPLEMENTED            107
# define SDC_ECM_R_DBUS_NAME_IS_VANISHED                  109
# define SDC_ECM_R_DBUS_OPEN_FAILED                       112
# define SDC_ECM_R_DISCONNECT_FAILED                      114
# define SDC_ECM_R_FAILED_TO_GET_KEY_HANDLER              117
# define SDC_ECM_R_FAILED_TO_SET_KEY_METHODS              126
# define SDC_ECM_R_FORBIDDEN_SIGN_BEFORE_SERVER_CERT_CHECK 128
# define SDC_ECM_R_FORBIDDEN_TO_TURN_CERT_CHECK_OFF_WHEN_RUN_AS_CLIENT 129
# define SDC_ECM_R_GATEWAY_CERT_CHECK_FAILED              106
# define SDC_ECM_R_GATEWAY_GET_CERTIFICATE_FAILED         116
# define SDC_ECM_R_GATEWAY_SIGN_FAILED                    120
# define SDC_ECM_R_HASH_NOT_CALCULATED                    127
# define SDC_ECM_R_INIT_FAILED                            100
# define SDC_ECM_R_INVALID_CA_SIGNATURE                   115
# define SDC_ECM_R_INVALID_INPUT                          101
# define SDC_ECM_R_INVALID_INPUT_ENGINE                   102
# define SDC_ECM_R_INVALID_KEY_ID                         119
# define SDC_ECM_R_INVALID_KEY_TYPE                       123
# define SDC_ECM_R_INVALID_PKEY                           124
# define SDC_ECM_R_INVALID_SSL_CONTEXT                    113
# define SDC_ECM_R_INVALID_STUNNEL_CONFIGURATION          122
# define SDC_ECM_R_LOAD_KEY_FAILED                        118
# define SDC_ECM_R_LOG_OPEN_FAILED                        108
# define SDC_ECM_R_METHOD_CALL_FAILED                     110
# define SDC_ECM_R_NOT_IMPLEMENTED                        103
# define SDC_ECM_R_NOT_SUPPORTED                          104
# define SDC_ECM_R_NO_MEM                                 105
# define SDC_ECM_R_PARAMETER_CAST_FAILED                  111
# define SDC_ECM_R_PARAMETER_HASH_TYPE_SHOULD_BE_ZERO     125
# define SDC_ECM_R_VERIFICATION_FAILED                    121

#ifdef  __cplusplus
}
#endif
#endif
